unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    ComboBox1: TComboBox;
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    ListBox1: TListBox;
    procedure Button1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    HInst : THandle;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
function EnumResFunc(hModule : THandle; lpszType : PChar; Form : TForm1) : Bool ; stdcall;
begin
  if (Cardinal(lpszType) and $FFFF0000) = 0 then
    Form.Combobox1.Items.Add(IntToStr(Integer(lpszType)))
  else
    Form.Combobox1.Items.Add(String(lpszType));
  Result := True;
end;

function EnumNamesFunc(hModule : THandle; lptype,lpName : PChar; Form : TForm1) : Bool; stdcall;
begin
  if (Cardinal(lpName) and $FFFF0000) = 0 then
    Form.Listbox1.Items.Add(IntToStr(Integer(lpName)))
  else
    Form.Listbox1.Items.Add(String(lpName));
  Result := True;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  with OpenDialog1 do
    if Execute then begin
      if HInst <> 0 then
        FreeLibrary(HInst);
      Combobox1.Items.Clear;
      HInst := LoadLibraryEx(PChar(FileName),0,LOAD_LIBRARY_AS_DATAFILE);
      if HInst > 0 then
        EnumResourceTypes(HInst,@EnumResFunc,LongInt(Self));
    end;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  if (Combobox1.Text <> '') and (HInst <> 0) then begin
    Listbox1.Items.Clear;
    try
      EnumResourceNames(HInst,MakeIntResource(StrToInt(Combobox1.Text)),@EnumNamesFunc,LongInt(Self));
    except
      On EconvertError do
        EnumResourceNames(HInst,PChar(Combobox1.Text),@EnumNamesFunc,LongInt(Self));
    end;
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  if HInst <> 0 then
    FreeLibrary(HInst);
end;

end.
